clear();
clc();
close all;                             	 		%Plots schließen

%KONFIGURATION---------------------------------------------------------------------
Y                   = @(x) (x.^2).*exp(x);    	%Gleichung eingeben (innerhalb Integral)
obereGrenze         = 3.0;              		%b
untereGrenze        = 0.0;              		%a
aQuantisierung(:)   = [4,8,16,32,64,128];
sKommastellenDouble = '%.6f';           		%Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%INITIALISIERUNG-------------------------------------------------------------------
iAnzahlQuantisierungen = size(aQuantisierung,2);
aWERTETABELLE(1,:)=["n", ...
                    "Fläche (summierte Trapez-Regel)", ...
                    "Fläche (summierte Simpson-Regel)", ...
                    "Fläche (analytisch)", ...
                    "Fehler absolut (summierte Trapez-Regel)", ...
                    "Fehler absolut (summierte Simpson-Regel)", ...
                    "Fehler relativ (summierte Trapez-Regel) [%]", ...
                    "Fehler relativ (summierte Simpson-Regel) [%]"];

%BERECHNUNG------------------------------------------------------------------------
dFLAECHE=integral(Y,untereGrenze,obereGrenze);
for(i=1:1:iAnzahlQuantisierungen)
    aWERTETABELLE(i+1,1)=num2str(aQuantisierung(i));
    aWERTETABELLE(i+1,2)=num2str(funktion_summierte_trapez_regel(Y, obereGrenze, untereGrenze, aQuantisierung(i), sKommastellenDouble),sKommastellenDouble);
    aWERTETABELLE(i+1,3)=num2str(funktion_summierte_simpson_regel(Y, obereGrenze, untereGrenze, aQuantisierung(i), sKommastellenDouble),sKommastellenDouble);
    aWERTETABELLE(i+1,4)=num2str(dFLAECHE,sKommastellenDouble);
    aWERTETABELLE(i+1,5)=num2str(str2double(aWERTETABELLE(i+1,2))-dFLAECHE,sKommastellenDouble);
    aWERTETABELLE(i+1,6)=num2str(str2double(aWERTETABELLE(i+1,3))-dFLAECHE,sKommastellenDouble);
    aWERTETABELLE(i+1,7)=num2str(((str2double(aWERTETABELLE(i+1,2))-dFLAECHE)/str2double(aWERTETABELLE(i+1,2)))*100,sKommastellenDouble);
    aWERTETABELLE(i+1,8)=num2str(((str2double(aWERTETABELLE(i+1,3))-dFLAECHE)/str2double(aWERTETABELLE(i+1,3)))*100,sKommastellenDouble);
end

%FUNKTIONSPLOT---------------------------------------------------------------------
xACHSE              = @(x) 0*x;
X(:)=aQuantisierung;
Y_relativerFehlerTrapez(:)=str2double(aWERTETABELLE(2:end,7));
Y_relativerFehlerSimpson=str2double(aWERTETABELLE(2:end,8));
plot(X,Y_relativerFehlerTrapez,'color','blue');
text(aQuantisierung(1),str2double(aWERTETABELLE(2,7)),'Trapez-Regel');
hold on;
plot(X,Y_relativerFehlerSimpson,'color','red');
text(aQuantisierung(1),str2double(aWERTETABELLE(2,8)),'Simpson-Regel');
hold on;
plot(X,xACHSE(X),'color','black');
hold on;
xlabel({'Quantisierung','n'});
ylabel({'relativer Fehler','[%]'});
grid on;                                											%Warten bis zur Plotausgabe
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE                  									%Workspace aufräumen